import funkin.backend.utils.FunkinParentDisabler;

var dark = new FlxSprite();
dark.makeGraphic(FlxG.width+10, FlxG.height+10, FlxColor.BLACK);
dark.alpha = 0.5;

var buffer:FlxSprite = new FlxSprite();
buffer.frames = Paths.getFrames("game/buffer");
buffer.animation.addByPrefix("loop", "buffer idle", 12, true);
buffer.antialiasing = true;


var parentDisabler:FunkinParentDisabler;

function postCreate() {
  window.frameRate = 48;
  add(parentDisabler = new FunkinParentDisabler());
  for (camera in FlxG.cameras.list) camera.active = false;

  subCam = new FlxCamera(0, 0, 960, 720);
  subCam.bgColor = 0;
  FlxG.cameras.add(subCam, false);
  dark.cameras = [subCam];
  add(dark);
  
  buffer.cameras = [subCam];
  buffer.screenCenter();
  buffer.animation.play('loop');
  add(buffer);
  
  trace("Buffering...");
  new FlxTimer().start(FlxG.random.float(0.1, 5), function(tmr:FlxTimer)
  {
    close();
  });
}

function destroy() {
  for (camera in FlxG.cameras.list) camera.active = true;
}